﻿var tasks = {
    context: $(".v-tasks"),
    datatable: null,
    refreshDataTable: function () {
        tasks.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".h-tasksTable").a4datatable({
            height: "full",
            ajaxAction: a4.getProjectAction("GetTasks", "Tasks"),
            columns: [
                { "Name": "Title", "Title": resources.TaskTitle, "Data": "Title" },
                { "Name": "UserName", "Title": resources.UserName, "Data": "UserName", "Class": "no-wrap" },
                { "Name": "CreatedOn", "Title": resources.CreatedOn, "Data": "CreatedOn", "Type": "datetime" },
                { "Name": "TerminatedOn", "Title": resources.TerminatedOn, "Data": "TerminatedOn", "Type": "datetime", "Visible": false, "HideInSelector": true },
                { "Name": "Progress", "Title": resources.Progress, "Data": "Progress", "HideInSelector": true },
                { "Name": "Result", "Title": resources.Result, "Data": "Result", "Visible": false, "HideInSelector": true }
            ],
            quickFilter: {
                "IncludeAll": false,
                "Items": [{ "Label": resources.ActiveTasks, "AjaxParams": { "type": 0 } },
                    { "Label": resources.TasksHistiry, "AjaxParams": { "type": 1 } }]
            },
            allowRowSelection: "[TaskType] == 0",
            toolBarItems: [{ "Action": "abort", "Label": resources.AbortTask, "DisplayCondition": function (data) { return data.TaskType == 0; } }],
            contextMenuItems: [{ "Action": "abort", "Label": resources.AbortTask, "DisplayCondition": function (data) { return data.TaskType == 0; } }],
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.pluck(rows, "Id");

                switch (action) {
                    case "abort":
                        tasks.abortTasks(ids);
                        break;
                }
            },
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "abort":
                        tasks.abortTasks([row.Id]);
                        break;
                }
            },
            applyQuickFilter: function (event, data) {
                var type = data.filter.params.type;
                $(this).a4datatable("toggleColumns", ["Progress"], type == 0);
                $(this).a4datatable("toggleColumns", ["TerminatedOn", "Result"], type == 1);
            },
            stateKey: "ProjectTasks",
            localizableTexts: { "Search": resources.SearchTasks }
        });
    },
    abortTasks: function (items, messageType) {
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        modalDialog.showConfirmDialog(confirmAbortMessageResources, function () {
            a4.callServerMethod(a4.getAction("AbortTasks", "Home", "Tasks"), { taskIds: items },
                function (result) {
                    tasks.refreshDataTable();
                });
        }, 220, 500, true, { "count": itemsCount });
    }
};

$(document).ready(function () {
    if ($(".v-tasks").length > 0) {
        tasks.initializeDataTable();
    }
});